/*
 * Decompiled with CFR 0.152.
 */
package com.technicalitiesmc.scm.circuit;

import com.technicalitiesmc.lib.circuit.component.ComponentSlot;
import com.technicalitiesmc.lib.math.IndexedShape;
import com.technicalitiesmc.scm.circuit.util.ComponentPos;
import com.technicalitiesmc.scm.circuit.util.ComponentSlotPos;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.VoxelShape;

public class CircuitHelper {
    public static final int SIZE = 8;
    public static final int SIZE_MINUS_ONE = 7;
    public static final int SIZE_PLUS_ONE = 9;
    public static final int HEIGHT = 4;
    public static final int SLOTS = ComponentSlot.VALUES.length;
    public static final int TOTAL_POSITIONS = 256 * SLOTS;

    public static ComponentSlotPos resolvePositionFromShapeIndex(int index) {
        int slot = Math.floorMod(index, SLOTS);
        index = Math.floorDiv(index, SLOTS);
        int z = Math.floorMod(index, 9) - 1;
        index = Math.floorDiv(index, 9);
        int x = Math.floorMod(index, 9) - 1;
        int y = Math.floorDiv(index, 9);
        return new ComponentSlotPos(x, y, z, ComponentSlot.VALUES[slot]);
    }

    public static int createShapeIndex(ComponentPos pos, ComponentSlot slot) {
        return ((pos.y() * 9 + pos.x() + 1) * 9 + pos.z() + 1) * SLOTS + slot.ordinal();
    }

    public static VoxelShape createShape(AABB aabb, ComponentPos pos, ComponentSlot slot) {
        return IndexedShape.create((int)CircuitHelper.createShapeIndex(pos, slot), (AABB)CircuitHelper.scaleAndTranslate(aabb, pos));
    }

    private static AABB scaleAndTranslate(AABB aabb, ComponentPos pos) {
        return new AABB(aabb.f_82288_ / 8.0, aabb.f_82289_ / 8.0, aabb.f_82290_ / 8.0, aabb.f_82291_ / 8.0, aabb.f_82292_ / 8.0, aabb.f_82293_ / 8.0).m_82386_(((double)pos.x() + 0.5) / 8.0, ((double)pos.y() + 1.0) / 8.0, ((double)pos.z() + 0.5) / 8.0);
    }

    public static int getIndex(ComponentPos pos, ComponentSlot slot) {
        return pos.x() + 8 * (pos.z() + 8 * (pos.y() + 4 * slot.ordinal()));
    }

    public static ComponentSlotPos getPositionFromIndex(int index) {
        int x = index % 8;
        int z = (index /= 8) % 8;
        int y = (index /= 8) % 4;
        int slot = index / 4;
        return new ComponentSlotPos(x, y, z, ComponentSlot.VALUES[slot]);
    }
}

